﻿using VA.TMP.Integration.VIMT.Messages.VideoVisit;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Create
{
    /// <summary>
    /// Create Response step.
    /// </summary>
    public class CreateResponseStep : FilterBase<VideoVisitCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VideoVisitCreateStateObject state)
        {
            if (state.UseFakeResponse)
            {
                state.VideoVisitCreateResponseMessage = new VideoVisitCreateResponseMessage
                    {
                        ExceptionMessage = "*****THIS IS FAKE DATA. DATA NOT SENT TO VVS*****",
                        ExceptionOccured = false,
                        SerializedInstance = state.SerializedAppointment
                    };
            }
            else
            {
                state.VideoVisitCreateResponseMessage = state.ExceptionOccured
                    ? new VideoVisitCreateResponseMessage { ExceptionOccured = true, ExceptionMessage = state.ExceptionMessage }
                    : new VideoVisitCreateResponseMessage
                    {
                        ExceptionMessage = string.Empty,
                        ExceptionOccured = false,
                        SerializedInstance = state.SerializedAppointment
                    };
            }
        }
    }
}